<?php

class EWRporta_Model_Threads extends XenForo_Model
{
	public function getRecent()
	{
		$options = XenForo_Application::get('options');

		$news = $this->_getDb()->fetchAll("
			SELECT xf_thread.*, xf_user.*, xf_post.message, xf_node.title AS node_title
				FROM xf_thread
				LEFT JOIN xf_user ON (xf_user.user_id = xf_thread.user_id)
				LEFT JOIN xf_post ON (xf_post.post_id = xf_thread.first_post_id)
				LEFT JOIN xf_node ON (xf_node.node_id = xf_thread.node_id)
			WHERE xf_thread.node_id = ?
				AND xf_thread.discussion_state = 'visible'
			ORDER BY xf_thread.post_date DESC
			LIMIT ?
		", array($options->EWRporta_newsforum, $options->EWRporta_newscount));

		foreach ($news AS &$post)
		{
			$bbCodeParser = new XenForo_BbCode_Parser(XenForo_BbCode_Formatter_Base::create());
			$post['HTML'] = substr($post['message'], 0, $options->EWRporta_newstrunc) . "...";
			$post['HTML'] = $bbCodeParser->render($post['HTML']);
		}

        return $news;
	}
}